function jsAlert(msg)
{
    var WSHShell = WScript.CreateObject("WScript.Shell");
    return WSHShell.Popup(msg, 10000, "CyberArticle", 0);
}

var objCAAutomation = new ActiveXObject("CyberArticle.CAAutomationApp");

function loadMacroString(stringName)
{
    var macroAppGUID = "{D8B7C0C6-D672-4be9-A483-7DBF8EF9B925}";
    //
    return objCAAutomation.LoadMacroString(macroAppGUID, stringName);
}

function pasteHtml(htmlText)
{
    try
    {
        var doc = objCAAutomation.CurrentArticleHtmlDocument;
        //
        var selection = doc.selection;
        //
        var range = selection.createRange();
        //
        range.pasteHTML(htmlText);
    }
    catch (e)
    {
        jsAlert(e.description);
    }
}

function insertTable()
{
    var doc = objCAAutomation.CurrentArticleHtmlDocument;
    if (doc == null)
        return;
    //
    var objWizCommonUI = new ActiveXObject("WizTools.WizCommonUI");

    var strInitColumnCount = objCAAutomation.Attribute("InsertTable_ColumnCount");
    var strInitRowCount = objCAAutomation.Attribute("InsertTable_RowCount");
    if (strInitColumnCount == null)
        strInitColumnCount = "";
    if (strInitRowCount == null)
        strInitRowCount = "";
    //
    var strColumnCount = objWizCommonUI.InputText(loadMacroString("InputColumnTitle"), loadMacroString("InputColumnDescription"), strInitColumnCount, false);
    if (strColumnCount == null)
        return;
    if (strColumnCount == "")
        return;
    if (isNaN(strColumnCount))
        return;
    //
    var strRowCount = objWizCommonUI.InputText(loadMacroString("InputRowTitle"), loadMacroString("InputRowDescription"), strInitRowCount, false);
    if (strRowCount == null)
        return;
    if (strRowCount == "")
        return;
    if (isNaN(strRowCount))
        return;
    //
    objCAAutomation.Attribute("InsertTable_ColumnCount") = strColumnCount;
    objCAAutomation.Attribute("InsertTable_RowCount") = strRowCount;
    //
    var nColumnCount = parseInt(strColumnCount, 10);
    var nRowCount = parseInt(strRowCount, 10);
    //
    if (nColumnCount <= 0)
        return;
    //
    if (nRowCount <= 0)
        return;
    //
    var strHtml = "<table width=\"100%\" border=\"1\">";
    for (var iRow = 0; iRow < nRowCount; iRow++)
    {
        strHtml = strHtml + "<tr>";
        for (var iColumn = 0; iColumn < nColumnCount; iColumn++)
        {
            strHtml = strHtml + "<td>&nbsp;</td>";
        }
        strHtml = strHtml + "</tr>";
    }
    strHtml = strHtml + "</table>";
    //
    pasteHtml(strHtml);
}

insertTable();